package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeResourceCollectionHealthResponse(
    cloudFormation: Option[
      Iterable[zio.aws.devopsguru.model.CloudFormationHealth]
    ] = None,
    service: Option[Iterable[zio.aws.devopsguru.model.ServiceHealth]] = None,
    nextToken: Option[UuidNextToken] = None,
    tags: Option[Iterable[zio.aws.devopsguru.model.TagHealth]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse = {
    import DescribeResourceCollectionHealthResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse
      .builder()
      .optionallyWith(
        cloudFormation.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudFormation)
      .optionallyWith(
        service.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.service)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse
      .wrap(buildAwsValue())
}
object DescribeResourceCollectionHealthResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse =
      zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse(
        cloudFormation.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        service.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudFormation
        : Option[List[zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly]]
    def service: Option[List[zio.aws.devopsguru.model.ServiceHealth.ReadOnly]]
    def nextToken: Option[UuidNextToken]
    def tags: Option[List[zio.aws.devopsguru.model.TagHealth.ReadOnly]]
    def getCloudFormation: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
    def getService: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ServiceHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("service", service)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.TagHealth.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse
  ) extends zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly {
    override val cloudFormation
        : Option[List[zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly]] =
      scala
        .Option(impl.cloudFormation())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.CloudFormationHealth.wrap(item)
          }.toList
        )
    override val service
        : Option[List[zio.aws.devopsguru.model.ServiceHealth.ReadOnly]] = scala
      .Option(impl.service())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ServiceHealth.wrap(item)
        }.toList
      )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val tags
        : Option[List[zio.aws.devopsguru.model.TagHealth.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.TagHealth.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthResponse
  ): zio.aws.devopsguru.model.DescribeResourceCollectionHealthResponse.ReadOnly =
    new Wrapper(impl)
}
