package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StartTimeRange(
    fromTime: Option[Timestamp] = None,
    toTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.StartTimeRange = {
    import StartTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.StartTimeRange
      .builder()
      .optionallyWith(fromTime.map(value => Timestamp.unwrap(value): Instant))(
        _.fromTime
      )
      .optionallyWith(toTime.map(value => Timestamp.unwrap(value): Instant))(
        _.toTime
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.StartTimeRange.ReadOnly =
    zio.aws.devopsguru.model.StartTimeRange.wrap(buildAwsValue())
}
object StartTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.StartTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.StartTimeRange =
      zio.aws.devopsguru.model.StartTimeRange(
        fromTime.map(value => value),
        toTime.map(value => value)
      )
    def fromTime: Option[Timestamp]
    def toTime: Option[Timestamp]
    def getFromTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("fromTime", fromTime)
    def getToTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("toTime", toTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.StartTimeRange
  ) extends zio.aws.devopsguru.model.StartTimeRange.ReadOnly {
    override val fromTime: Option[Timestamp] = scala
      .Option(impl.fromTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
    override val toTime: Option[Timestamp] = scala
      .Option(impl.toTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.StartTimeRange
  ): zio.aws.devopsguru.model.StartTimeRange.ReadOnly = new Wrapper(impl)
}
