package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsMetricUnit,
  PerformanceInsightsMetricDisplayName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PerformanceInsightsMetricsDetail(
    metricDisplayName: Option[PerformanceInsightsMetricDisplayName] = None,
    unit: Option[PerformanceInsightsMetricUnit] = None,
    metricQuery: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery
    ] = None,
    referenceData: Option[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsReferenceData]
    ] = None,
    statsAtAnomaly: Option[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsStat]
    ] = None,
    statsAtBaseline: Option[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsStat]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail = {
    import PerformanceInsightsMetricsDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
      .builder()
      .optionallyWith(
        metricDisplayName.map(value =>
          PerformanceInsightsMetricDisplayName.unwrap(value): java.lang.String
        )
      )(_.metricDisplayName)
      .optionallyWith(
        unit.map(value =>
          PerformanceInsightsMetricUnit.unwrap(value): java.lang.String
        )
      )(_.unit)
      .optionallyWith(metricQuery.map(value => value.buildAwsValue()))(
        _.metricQuery
      )
      .optionallyWith(
        referenceData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceData)
      .optionallyWith(
        statsAtAnomaly.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statsAtAnomaly)
      .optionallyWith(
        statsAtBaseline.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statsAtBaseline)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail
      .wrap(buildAwsValue())
}
object PerformanceInsightsMetricsDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail =
      zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail(
        metricDisplayName.map(value => value),
        unit.map(value => value),
        metricQuery.map(value => value.asEditable),
        referenceData.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statsAtAnomaly.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statsAtBaseline.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def metricDisplayName: Option[PerformanceInsightsMetricDisplayName]
    def unit: Option[PerformanceInsightsMetricUnit]
    def metricQuery: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ]
    def referenceData: Option[
      List[zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly]
    ]
    def statsAtAnomaly: Option[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ]
    def statsAtBaseline: Option[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ]
    def getMetricDisplayName
        : ZIO[Any, AwsError, PerformanceInsightsMetricDisplayName] =
      AwsError.unwrapOptionField("metricDisplayName", metricDisplayName)
    def getUnit: ZIO[Any, AwsError, PerformanceInsightsMetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
    def getMetricQuery: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ] = AwsError.unwrapOptionField("metricQuery", metricQuery)
    def getReferenceData: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly
    ]] = AwsError.unwrapOptionField("referenceData", referenceData)
    def getStatsAtAnomaly: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly
    ]] = AwsError.unwrapOptionField("statsAtAnomaly", statsAtAnomaly)
    def getStatsAtBaseline: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly
    ]] = AwsError.unwrapOptionField("statsAtBaseline", statsAtBaseline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
  ) extends zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly {
    override val metricDisplayName
        : Option[PerformanceInsightsMetricDisplayName] = scala
      .Option(impl.metricDisplayName())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .PerformanceInsightsMetricDisplayName(value)
      )
    override val unit: Option[PerformanceInsightsMetricUnit] = scala
      .Option(impl.unit())
      .map(value =>
        zio.aws.devopsguru.model.primitives.PerformanceInsightsMetricUnit(value)
      )
    override val metricQuery: Option[
      zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.ReadOnly
    ] = scala
      .Option(impl.metricQuery())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsMetricQuery.wrap(value)
      )
    override val referenceData: Option[
      List[zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly]
    ] = scala
      .Option(impl.referenceData())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsReferenceData.wrap(item)
        }.toList
      )
    override val statsAtAnomaly: Option[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ] = scala
      .Option(impl.statsAtAnomaly())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsStat.wrap(item)
        }.toList
      )
    override val statsAtBaseline: Option[
      List[zio.aws.devopsguru.model.PerformanceInsightsStat.ReadOnly]
    ] = scala
      .Option(impl.statsAtBaseline())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsStat.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricsDetail
  ): zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly =
    new Wrapper(impl)
}
