package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  AwsAccountId,
  UuidNextToken,
  InsightId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListRecommendationsRequest(
    insightId: InsightId,
    nextToken: Option[UuidNextToken] = None,
    locale: Option[zio.aws.devopsguru.model.Locale] = None,
    accountId: Option[AwsAccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest = {
    import ListRecommendationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(locale.map(value => value.unwrap))(_.locale)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListRecommendationsRequest.ReadOnly =
    zio.aws.devopsguru.model.ListRecommendationsRequest.wrap(buildAwsValue())
}
object ListRecommendationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListRecommendationsRequest =
      zio.aws.devopsguru.model.ListRecommendationsRequest(
        insightId,
        nextToken.map(value => value),
        locale.map(value => value),
        accountId.map(value => value)
      )
    def insightId: InsightId
    def nextToken: Option[UuidNextToken]
    def locale: Option[zio.aws.devopsguru.model.Locale]
    def accountId: Option[AwsAccountId]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getLocale: ZIO[Any, AwsError, zio.aws.devopsguru.model.Locale] =
      AwsError.unwrapOptionField("locale", locale)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest
  ) extends zio.aws.devopsguru.model.ListRecommendationsRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.insightId())
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val locale: Option[zio.aws.devopsguru.model.Locale] = scala
      .Option(impl.locale())
      .map(value => zio.aws.devopsguru.model.Locale.wrap(value))
    override val accountId: Option[AwsAccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListRecommendationsRequest
  ): zio.aws.devopsguru.model.ListRecommendationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
