package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.StackName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CloudFormationHealth(
    stackName: Option[StackName] = None,
    insight: Option[zio.aws.devopsguru.model.InsightHealth] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth = {
    import CloudFormationHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
      .builder()
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly =
    zio.aws.devopsguru.model.CloudFormationHealth.wrap(buildAwsValue())
}
object CloudFormationHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.CloudFormationHealth =
      zio.aws.devopsguru.model.CloudFormationHealth(
        stackName.map(value => value),
        insight.map(value => value.asEditable)
      )
    def stackName: Option[StackName]
    def insight: Option[zio.aws.devopsguru.model.InsightHealth.ReadOnly]
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getInsight
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightHealth.ReadOnly] =
      AwsError.unwrapOptionField("insight", insight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
  ) extends zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly {
    override val stackName: Option[StackName] = scala
      .Option(impl.stackName())
      .map(value => zio.aws.devopsguru.model.primitives.StackName(value))
    override val insight
        : Option[zio.aws.devopsguru.model.InsightHealth.ReadOnly] = scala
      .Option(impl.insight())
      .map(value => zio.aws.devopsguru.model.InsightHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationHealth
  ): zio.aws.devopsguru.model.CloudFormationHealth.ReadOnly = new Wrapper(impl)
}
