package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsMetricLimitInteger,
  PerformanceInsightsMetricDimension,
  PerformanceInsightsMetricGroup
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PerformanceInsightsMetricDimensionGroup(
    group: Option[PerformanceInsightsMetricGroup] = None,
    dimensions: Option[Iterable[PerformanceInsightsMetricDimension]] = None,
    limit: Option[PerformanceInsightsMetricLimitInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup = {
    import PerformanceInsightsMetricDimensionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
      .builder()
      .optionallyWith(
        group.map(value =>
          PerformanceInsightsMetricGroup.unwrap(value): java.lang.String
        )
      )(_.group)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            PerformanceInsightsMetricDimension.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        limit.map(value =>
          PerformanceInsightsMetricLimitInteger.unwrap(value): Integer
        )
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup
      .wrap(buildAwsValue())
}
object PerformanceInsightsMetricDimensionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup =
      zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup(
        group.map(value => value),
        dimensions.map(value => value),
        limit.map(value => value)
      )
    def group: Option[PerformanceInsightsMetricGroup]
    def dimensions: Option[List[PerformanceInsightsMetricDimension]]
    def limit: Option[PerformanceInsightsMetricLimitInteger]
    def getGroup: ZIO[Any, AwsError, PerformanceInsightsMetricGroup] =
      AwsError.unwrapOptionField("group", group)
    def getDimensions
        : ZIO[Any, AwsError, List[PerformanceInsightsMetricDimension]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getLimit: ZIO[Any, AwsError, PerformanceInsightsMetricLimitInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
  ) extends zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly {
    override val group: Option[PerformanceInsightsMetricGroup] = scala
      .Option(impl.group())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .PerformanceInsightsMetricGroup(value)
      )
    override val dimensions: Option[List[PerformanceInsightsMetricDimension]] =
      scala
        .Option(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives
              .PerformanceInsightsMetricDimension(item)
          }.toList
        )
    override val limit: Option[PerformanceInsightsMetricLimitInteger] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .PerformanceInsightsMetricLimitInteger(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
  ): zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly =
    new Wrapper(impl)
}
