package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  RecommendationRelatedCloudWatchMetricsSourceNamespace,
  RecommendationRelatedCloudWatchMetricsSourceMetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecommendationRelatedCloudWatchMetricsSourceDetail(
    metricName: Option[RecommendationRelatedCloudWatchMetricsSourceMetricName] =
      None,
    namespace: Option[RecommendationRelatedCloudWatchMetricsSourceNamespace] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail = {
    import RecommendationRelatedCloudWatchMetricsSourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
      .builder()
      .optionallyWith(
        metricName.map(value =>
          RecommendationRelatedCloudWatchMetricsSourceMetricName.unwrap(
            value
          ): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(
        namespace.map(value =>
          RecommendationRelatedCloudWatchMetricsSourceNamespace.unwrap(
            value
          ): java.lang.String
        )
      )(_.namespace)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
      .wrap(buildAwsValue())
}
object RecommendationRelatedCloudWatchMetricsSourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail =
      zio.aws.devopsguru.model
        .RecommendationRelatedCloudWatchMetricsSourceDetail(
          metricName.map(value => value),
          namespace.map(value => value)
        )
    def metricName
        : Option[RecommendationRelatedCloudWatchMetricsSourceMetricName]
    def namespace: Option[RecommendationRelatedCloudWatchMetricsSourceNamespace]
    def getMetricName: ZIO[
      Any,
      AwsError,
      RecommendationRelatedCloudWatchMetricsSourceMetricName
    ] = AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[
      Any,
      AwsError,
      RecommendationRelatedCloudWatchMetricsSourceNamespace
    ] = AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ) extends zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly {
    override val metricName
        : Option[RecommendationRelatedCloudWatchMetricsSourceMetricName] = scala
      .Option(impl.metricName())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .RecommendationRelatedCloudWatchMetricsSourceMetricName(value)
      )
    override val namespace
        : Option[RecommendationRelatedCloudWatchMetricsSourceNamespace] = scala
      .Option(impl.namespace())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .RecommendationRelatedCloudWatchMetricsSourceNamespace(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ): zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly =
    new Wrapper(impl)
}
