package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{OrganizationalUnitId, AwsAccountId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationHealthRequest(
    accountIds: Option[Iterable[AwsAccountId]] = None,
    organizationalUnitIds: Option[Iterable[OrganizationalUnitId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest = {
    import DescribeOrganizationHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest
      .builder()
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeOrganizationHealthRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeOrganizationHealthRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeOrganizationHealthRequest =
      zio.aws.devopsguru.model.DescribeOrganizationHealthRequest(
        accountIds.map(value => value),
        organizationalUnitIds.map(value => value)
      )
    def accountIds: Option[List[AwsAccountId]]
    def organizationalUnitIds: Option[List[OrganizationalUnitId]]
    def getAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest
  ) extends zio.aws.devopsguru.model.DescribeOrganizationHealthRequest.ReadOnly {
    override val accountIds: Option[List[AwsAccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val organizationalUnitIds: Option[List[OrganizationalUnitId]] =
      scala
        .Option(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationHealthRequest
  ): zio.aws.devopsguru.model.DescribeOrganizationHealthRequest.ReadOnly =
    new Wrapper(impl)
}
