package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait CloudWatchMetricDataStatusCode {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode
}
object CloudWatchMetricDataStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode
  ): zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode = value match {
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.COMPLETE =>
      val r = Complete
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.INTERNAL_ERROR =>
      val r = InternalError
      r
    case software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.PARTIAL_DATA =>
      val r = PartialData
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Complete
      extends zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.COMPLETE
  }
  case object InternalError
      extends zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.INTERNAL_ERROR
  }
  case object PartialData
      extends zio.aws.devopsguru.model.CloudWatchMetricDataStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode =
      software.amazon.awssdk.services.devopsguru.model.CloudWatchMetricDataStatusCode.PARTIAL_DATA
  }
}
