package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateResourceCollectionFilter(
    cloudFormation: Option[
      zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter
    ] = None,
    tags: Option[Iterable[zio.aws.devopsguru.model.UpdateTagCollectionFilter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionFilter = {
    import UpdateResourceCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionFilter
      .builder()
      .optionallyWith(cloudFormation.map(value => value.buildAwsValue()))(
        _.cloudFormation
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateResourceCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.UpdateResourceCollectionFilter
      .wrap(buildAwsValue())
}
object UpdateResourceCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateResourceCollectionFilter =
      zio.aws.devopsguru.model.UpdateResourceCollectionFilter(
        cloudFormation.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudFormation: Option[
      zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter.ReadOnly
    ]
    def tags: Option[
      List[zio.aws.devopsguru.model.UpdateTagCollectionFilter.ReadOnly]
    ]
    def getCloudFormation: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("cloudFormation", cloudFormation)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.UpdateTagCollectionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionFilter
  ) extends zio.aws.devopsguru.model.UpdateResourceCollectionFilter.ReadOnly {
    override val cloudFormation: Option[
      zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter.ReadOnly
    ] = scala
      .Option(impl.cloudFormation())
      .map(value =>
        zio.aws.devopsguru.model.UpdateCloudFormationCollectionFilter
          .wrap(value)
      )
    override val tags: Option[
      List[zio.aws.devopsguru.model.UpdateTagCollectionFilter.ReadOnly]
    ] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.UpdateTagCollectionFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateResourceCollectionFilter
  ): zio.aws.devopsguru.model.UpdateResourceCollectionFilter.ReadOnly =
    new Wrapper(impl)
}
