package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  RecommendationRelatedAnomalyResourceType,
  RecommendationRelatedAnomalyResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RecommendationRelatedAnomalyResource(
    name: Option[RecommendationRelatedAnomalyResourceName] = None,
    `type`: Option[RecommendationRelatedAnomalyResourceType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalyResource = {
    import RecommendationRelatedAnomalyResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalyResource
      .builder()
      .optionallyWith(
        name.map(value =>
          RecommendationRelatedAnomalyResourceName.unwrap(
            value
          ): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        `type`.map(value =>
          RecommendationRelatedAnomalyResourceType.unwrap(
            value
          ): java.lang.String
        )
      )(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource
      .wrap(buildAwsValue())
}
object RecommendationRelatedAnomalyResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalyResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource =
      zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource(
        name.map(value => value),
        `type`.map(value => value)
      )
    def name: Option[RecommendationRelatedAnomalyResourceName]
    def `type`: Option[RecommendationRelatedAnomalyResourceType]
    def getName: ZIO[Any, AwsError, RecommendationRelatedAnomalyResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, RecommendationRelatedAnomalyResourceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalyResource
  ) extends zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly {
    override val name: Option[RecommendationRelatedAnomalyResourceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .RecommendationRelatedAnomalyResourceName(value)
      )
    override val `type`: Option[RecommendationRelatedAnomalyResourceType] =
      scala
        .Option(impl.`type`())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .RecommendationRelatedAnomalyResourceType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalyResource
  ): zio.aws.devopsguru.model.RecommendationRelatedAnomalyResource.ReadOnly =
    new Wrapper(impl)
}
