package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  OrganizationResourceCollectionMaxResults,
  UuidNextToken,
  OrganizationalUnitId,
  AwsAccountId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationResourceCollectionHealthRequest(
    organizationResourceCollectionType: zio.aws.devopsguru.model.OrganizationResourceCollectionType,
    accountIds: Option[Iterable[AwsAccountId]] = None,
    organizationalUnitIds: Option[Iterable[OrganizationalUnitId]] = None,
    nextToken: Option[UuidNextToken] = None,
    maxResults: Option[OrganizationResourceCollectionMaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest = {
    import DescribeOrganizationResourceCollectionHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
      .builder()
      .organizationResourceCollectionType(
        organizationResourceCollectionType.unwrap
      )
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          OrganizationResourceCollectionMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationResourceCollectionHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest =
      zio.aws.devopsguru.model
        .DescribeOrganizationResourceCollectionHealthRequest(
          organizationResourceCollectionType,
          accountIds.map(value => value),
          organizationalUnitIds.map(value => value),
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def organizationResourceCollectionType
        : zio.aws.devopsguru.model.OrganizationResourceCollectionType
    def accountIds: Option[List[AwsAccountId]]
    def organizationalUnitIds: Option[List[OrganizationalUnitId]]
    def nextToken: Option[UuidNextToken]
    def maxResults: Option[OrganizationResourceCollectionMaxResults]
    def getOrganizationResourceCollectionType: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.OrganizationResourceCollectionType
    ] = ZIO.succeed(organizationResourceCollectionType)
    def getAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults
        : ZIO[Any, AwsError, OrganizationResourceCollectionMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
  ) extends zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.ReadOnly {
    override val organizationResourceCollectionType
        : zio.aws.devopsguru.model.OrganizationResourceCollectionType =
      zio.aws.devopsguru.model.OrganizationResourceCollectionType
        .wrap(impl.organizationResourceCollectionType())
    override val accountIds: Option[List[AwsAccountId]] = scala
      .Option(impl.accountIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.AwsAccountId(item)
        }.toList
      )
    override val organizationalUnitIds: Option[List[OrganizationalUnitId]] =
      scala
        .Option(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val maxResults: Option[OrganizationResourceCollectionMaxResults] =
      scala
        .Option(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .OrganizationResourceCollectionMaxResults(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest
  ): zio.aws.devopsguru.model.DescribeOrganizationResourceCollectionHealthRequest.ReadOnly =
    new Wrapper(impl)
}
