package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceIntegrationRequest(
    serviceIntegration: zio.aws.devopsguru.model.UpdateServiceIntegrationConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest = {
    import UpdateServiceIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest
      .builder()
      .serviceIntegration(serviceIntegration.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateServiceIntegrationRequest.ReadOnly =
    zio.aws.devopsguru.model.UpdateServiceIntegrationRequest
      .wrap(buildAwsValue())
}
object UpdateServiceIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateServiceIntegrationRequest =
      zio.aws.devopsguru.model
        .UpdateServiceIntegrationRequest(serviceIntegration.asEditable)
    def serviceIntegration
        : zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly
    def getServiceIntegration: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly
    ] = ZIO.succeed(serviceIntegration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest
  ) extends zio.aws.devopsguru.model.UpdateServiceIntegrationRequest.ReadOnly {
    override val serviceIntegration
        : zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly =
      zio.aws.devopsguru.model.UpdateServiceIntegrationConfig
        .wrap(impl.serviceIntegration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationRequest
  ): zio.aws.devopsguru.model.UpdateServiceIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
