package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters.*
sealed trait InsightSeverity {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.InsightSeverity
}
object InsightSeverity {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.InsightSeverity
  ): zio.aws.devopsguru.model.InsightSeverity = value match {
    case software.amazon.awssdk.services.devopsguru.model.InsightSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightSeverity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightSeverity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.devopsguru.model.InsightSeverity.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.devopsguru.model.InsightSeverity {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightSeverity =
      software.amazon.awssdk.services.devopsguru.model.InsightSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.devopsguru.model.InsightSeverity {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightSeverity =
      software.amazon.awssdk.services.devopsguru.model.InsightSeverity.LOW
  }
  case object MEDIUM extends zio.aws.devopsguru.model.InsightSeverity {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightSeverity =
      software.amazon.awssdk.services.devopsguru.model.InsightSeverity.MEDIUM
  }
  case object HIGH extends zio.aws.devopsguru.model.InsightSeverity {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.InsightSeverity =
      software.amazon.awssdk.services.devopsguru.model.InsightSeverity.HIGH
  }
}
