package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.InsightId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InsightFeedback(
    id: Option[InsightId] = None,
    feedback: Option[zio.aws.devopsguru.model.InsightFeedbackOption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.InsightFeedback = {
    import InsightFeedback.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.InsightFeedback
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(feedback.map(value => value.unwrap))(_.feedback)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.InsightFeedback.ReadOnly =
    zio.aws.devopsguru.model.InsightFeedback.wrap(buildAwsValue())
}
object InsightFeedback {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.InsightFeedback
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.InsightFeedback =
      zio.aws.devopsguru.model
        .InsightFeedback(id.map(value => value), feedback.map(value => value))
    def id: Option[InsightId]
    def feedback: Option[zio.aws.devopsguru.model.InsightFeedbackOption]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getFeedback
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightFeedbackOption] =
      AwsError.unwrapOptionField("feedback", feedback)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.InsightFeedback
  ) extends zio.aws.devopsguru.model.InsightFeedback.ReadOnly {
    override val id: Option[InsightId] = scala
      .Option(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val feedback
        : Option[zio.aws.devopsguru.model.InsightFeedbackOption] = scala
      .Option(impl.feedback())
      .map(value => zio.aws.devopsguru.model.InsightFeedbackOption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.InsightFeedback
  ): zio.aws.devopsguru.model.InsightFeedback.ReadOnly = new Wrapper(impl)
}
