package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PredictionTimeRange(
    startTime: Timestamp,
    endTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange = {
    import PredictionTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly =
    zio.aws.devopsguru.model.PredictionTimeRange.wrap(buildAwsValue())
}
object PredictionTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PredictionTimeRange =
      zio.aws.devopsguru.model
        .PredictionTimeRange(startTime, endTime.map(value => value))
    def startTime: Timestamp
    def endTime: Option[Timestamp]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange
  ) extends zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.startTime())
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PredictionTimeRange
  ): zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly = new Wrapper(impl)
}
