package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NotificationChannelConfig(
    sns: zio.aws.devopsguru.model.SnsChannelConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig = {
    import NotificationChannelConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
      .builder()
      .sns(sns.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly =
    zio.aws.devopsguru.model.NotificationChannelConfig.wrap(buildAwsValue())
}
object NotificationChannelConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.NotificationChannelConfig =
      zio.aws.devopsguru.model.NotificationChannelConfig(sns.asEditable)
    def sns: zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly
    def getSns: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly
    ] = ZIO.succeed(sns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
  ) extends zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly {
    override val sns: zio.aws.devopsguru.model.SnsChannelConfig.ReadOnly =
      zio.aws.devopsguru.model.SnsChannelConfig.wrap(impl.sns())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannelConfig
  ): zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly = new Wrapper(
    impl
  )
}
