package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  Cost,
  CostEstimationServiceResourceCount,
  ResourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ServiceResourceCost(
    `type`: Option[ResourceType] = None,
    state: Option[zio.aws.devopsguru.model.CostEstimationServiceResourceState] =
      None,
    count: Option[CostEstimationServiceResourceCount] = None,
    unitCost: Option[Cost] = None,
    cost: Option[Cost] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost = {
    import ServiceResourceCost.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost
      .builder()
      .optionallyWith(
        `type`.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        count.map(value =>
          CostEstimationServiceResourceCount.unwrap(value): Integer
        )
      )(_.count)
      .optionallyWith(
        unitCost.map(value => Cost.unwrap(value): java.lang.Double)
      )(_.unitCost)
      .optionallyWith(cost.map(value => Cost.unwrap(value): java.lang.Double))(
        _.cost
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly =
    zio.aws.devopsguru.model.ServiceResourceCost.wrap(buildAwsValue())
}
object ServiceResourceCost {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ServiceResourceCost =
      zio.aws.devopsguru.model.ServiceResourceCost(
        `type`.map(value => value),
        state.map(value => value),
        count.map(value => value),
        unitCost.map(value => value),
        cost.map(value => value)
      )
    def `type`: Option[ResourceType]
    def state
        : Option[zio.aws.devopsguru.model.CostEstimationServiceResourceState]
    def count: Option[CostEstimationServiceResourceCount]
    def unitCost: Option[Cost]
    def cost: Option[Cost]
    def getType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CostEstimationServiceResourceState
    ] = AwsError.unwrapOptionField("state", state)
    def getCount: ZIO[Any, AwsError, CostEstimationServiceResourceCount] =
      AwsError.unwrapOptionField("count", count)
    def getUnitCost: ZIO[Any, AwsError, Cost] =
      AwsError.unwrapOptionField("unitCost", unitCost)
    def getCost: ZIO[Any, AwsError, Cost] =
      AwsError.unwrapOptionField("cost", cost)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost
  ) extends zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly {
    override val `type`: Option[ResourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devopsguru.model.primitives.ResourceType(value))
    override val state
        : Option[zio.aws.devopsguru.model.CostEstimationServiceResourceState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.devopsguru.model.CostEstimationServiceResourceState
            .wrap(value)
        )
    override val count: Option[CostEstimationServiceResourceCount] = scala
      .Option(impl.count())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .CostEstimationServiceResourceCount(value)
      )
    override val unitCost: Option[Cost] = scala
      .Option(impl.unitCost())
      .map(value => zio.aws.devopsguru.model.primitives.Cost(value))
    override val cost: Option[Cost] = scala
      .Option(impl.cost())
      .map(value => zio.aws.devopsguru.model.primitives.Cost(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ServiceResourceCost
  ): zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly = new Wrapper(impl)
}
