package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SearchInsightsFilters(
    severities: Option[Iterable[zio.aws.devopsguru.model.InsightSeverity]] =
      None,
    statuses: Option[Iterable[zio.aws.devopsguru.model.InsightStatus]] = None,
    resourceCollection: Option[zio.aws.devopsguru.model.ResourceCollection] =
      None,
    serviceCollection: Option[zio.aws.devopsguru.model.ServiceCollection] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.SearchInsightsFilters = {
    import SearchInsightsFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.SearchInsightsFilters
      .builder()
      .optionallyWith(
        severities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.severitiesWithStrings)
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusesWithStrings)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.SearchInsightsFilters.ReadOnly =
    zio.aws.devopsguru.model.SearchInsightsFilters.wrap(buildAwsValue())
}
object SearchInsightsFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.SearchInsightsFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.SearchInsightsFilters =
      zio.aws.devopsguru.model.SearchInsightsFilters(
        severities.map(value => value),
        statuses.map(value => value),
        resourceCollection.map(value => value.asEditable),
        serviceCollection.map(value => value.asEditable)
      )
    def severities: Option[List[zio.aws.devopsguru.model.InsightSeverity]]
    def statuses: Option[List[zio.aws.devopsguru.model.InsightStatus]]
    def resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def serviceCollection
        : Option[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def getSeverities
        : ZIO[Any, AwsError, List[zio.aws.devopsguru.model.InsightSeverity]] =
      AwsError.unwrapOptionField("severities", severities)
    def getStatuses
        : ZIO[Any, AwsError, List[zio.aws.devopsguru.model.InsightStatus]] =
      AwsError.unwrapOptionField("statuses", statuses)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchInsightsFilters
  ) extends zio.aws.devopsguru.model.SearchInsightsFilters.ReadOnly {
    override val severities
        : Option[List[zio.aws.devopsguru.model.InsightSeverity]] = scala
      .Option(impl.severities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.InsightSeverity.wrap(item)
        }.toList
      )
    override val statuses
        : Option[List[zio.aws.devopsguru.model.InsightStatus]] = scala
      .Option(impl.statuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.InsightStatus.wrap(item)
        }.toList
      )
    override val resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] = scala
      .Option(impl.resourceCollection())
      .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val serviceCollection
        : Option[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] = scala
      .Option(impl.serviceCollection())
      .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.SearchInsightsFilters
  ): zio.aws.devopsguru.model.SearchInsightsFilters.ReadOnly = new Wrapper(impl)
}
