package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.PerformanceInsightsReferenceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PerformanceInsightsReferenceData(
    name: Option[PerformanceInsightsReferenceName] = None,
    comparisonValues: Option[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceData = {
    import PerformanceInsightsReferenceData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceData
      .builder()
      .optionallyWith(
        name.map(value =>
          PerformanceInsightsReferenceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(comparisonValues.map(value => value.buildAwsValue()))(
        _.comparisonValues
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsReferenceData
      .wrap(buildAwsValue())
}
object PerformanceInsightsReferenceData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.PerformanceInsightsReferenceData =
      zio.aws.devopsguru.model.PerformanceInsightsReferenceData(
        name.map(value => value),
        comparisonValues.map(value => value.asEditable)
      )
    def name: Option[PerformanceInsightsReferenceName]
    def comparisonValues: Option[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, PerformanceInsightsReferenceName] =
      AwsError.unwrapOptionField("name", name)
    def getComparisonValues: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues.ReadOnly
    ] = AwsError.unwrapOptionField("comparisonValues", comparisonValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceData
  ) extends zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly {
    override val name: Option[PerformanceInsightsReferenceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.devopsguru.model.primitives
          .PerformanceInsightsReferenceName(value)
      )
    override val comparisonValues: Option[
      zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues.ReadOnly
    ] = scala
      .Option(impl.comparisonValues())
      .map(value =>
        zio.aws.devopsguru.model.PerformanceInsightsReferenceComparisonValues
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsReferenceData
  ): zio.aws.devopsguru.model.PerformanceInsightsReferenceData.ReadOnly =
    new Wrapper(impl)
}
