package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeResourceCollectionHealthRequest(
    resourceCollectionType: zio.aws.devopsguru.model.ResourceCollectionType,
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest = {
    import DescribeResourceCollectionHealthRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest
      .builder()
      .resourceCollectionType(resourceCollectionType.unwrap)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.DescribeResourceCollectionHealthRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeResourceCollectionHealthRequest
      .wrap(buildAwsValue())
}
object DescribeResourceCollectionHealthRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.DescribeResourceCollectionHealthRequest =
      zio.aws.devopsguru.model.DescribeResourceCollectionHealthRequest(
        resourceCollectionType,
        nextToken.map(value => value)
      )
    def resourceCollectionType: zio.aws.devopsguru.model.ResourceCollectionType
    def nextToken: Option[UuidNextToken]
    def getResourceCollectionType
        : ZIO[Any, Nothing, zio.aws.devopsguru.model.ResourceCollectionType] =
      ZIO.succeed(resourceCollectionType)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest
  ) extends zio.aws.devopsguru.model.DescribeResourceCollectionHealthRequest.ReadOnly {
    override val resourceCollectionType
        : zio.aws.devopsguru.model.ResourceCollectionType =
      zio.aws.devopsguru.model.ResourceCollectionType
        .wrap(impl.resourceCollectionType())
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeResourceCollectionHealthRequest
  ): zio.aws.devopsguru.model.DescribeResourceCollectionHealthRequest.ReadOnly =
    new Wrapper(impl)
}
