package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateServiceIntegrationConfig(
    opsCenter: Option[zio.aws.devopsguru.model.OpsCenterIntegrationConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig = {
    import UpdateServiceIntegrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
      .builder()
      .optionallyWith(opsCenter.map(value => value.buildAwsValue()))(
        _.opsCenter
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly =
    zio.aws.devopsguru.model.UpdateServiceIntegrationConfig
      .wrap(buildAwsValue())
}
object UpdateServiceIntegrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.UpdateServiceIntegrationConfig =
      zio.aws.devopsguru.model.UpdateServiceIntegrationConfig(
        opsCenter.map(value => value.asEditable)
      )
    def opsCenter
        : Option[zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly]
    def getOpsCenter: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly
    ] = AwsError.unwrapOptionField("opsCenter", opsCenter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
  ) extends zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly {
    override val opsCenter
        : Option[zio.aws.devopsguru.model.OpsCenterIntegrationConfig.ReadOnly] =
      scala
        .Option(impl.opsCenter())
        .map(value =>
          zio.aws.devopsguru.model.OpsCenterIntegrationConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.UpdateServiceIntegrationConfig
  ): zio.aws.devopsguru.model.UpdateServiceIntegrationConfig.ReadOnly =
    new Wrapper(impl)
}
