package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AnomalyReportedTimeRange(
    openTime: Timestamp,
    closeTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange = {
    import AnomalyReportedTimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange
      .builder()
      .openTime(Timestamp.unwrap(openTime): Instant)
      .optionallyWith(closeTime.map(value => Timestamp.unwrap(value): Instant))(
        _.closeTime
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly =
    zio.aws.devopsguru.model.AnomalyReportedTimeRange.wrap(buildAwsValue())
}
object AnomalyReportedTimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalyReportedTimeRange =
      zio.aws.devopsguru.model
        .AnomalyReportedTimeRange(openTime, closeTime.map(value => value))
    def openTime: Timestamp
    def closeTime: Option[Timestamp]
    def getOpenTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(openTime)
    def getCloseTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("closeTime", closeTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange
  ) extends zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly {
    override val openTime: Timestamp =
      zio.aws.devopsguru.model.primitives.Timestamp(impl.openTime())
    override val closeTime: Option[Timestamp] = scala
      .Option(impl.closeTime())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalyReportedTimeRange
  ): zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly = new Wrapper(
    impl
  )
}
