package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.NotificationChannelId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveNotificationChannelRequest(id: NotificationChannelId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest = {
    import RemoveNotificationChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest
      .builder()
      .id(NotificationChannelId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RemoveNotificationChannelRequest.ReadOnly =
    zio.aws.devopsguru.model.RemoveNotificationChannelRequest
      .wrap(buildAwsValue())
}
object RemoveNotificationChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.RemoveNotificationChannelRequest =
      zio.aws.devopsguru.model.RemoveNotificationChannelRequest(id)
    def id: NotificationChannelId
    def getId: ZIO[Any, Nothing, NotificationChannelId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest
  ) extends zio.aws.devopsguru.model.RemoveNotificationChannelRequest.ReadOnly {
    override val id: NotificationChannelId =
      zio.aws.devopsguru.model.primitives.NotificationChannelId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RemoveNotificationChannelRequest
  ): zio.aws.devopsguru.model.RemoveNotificationChannelRequest.ReadOnly =
    new Wrapper(impl)
}
