package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AnomalySourceDetails(
    cloudWatchMetrics: Optional[
      Iterable[zio.aws.devopsguru.model.CloudWatchMetricsDetail]
    ] = Optional.Absent,
    performanceInsightsMetrics: Optional[
      Iterable[zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails = {
    import AnomalySourceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails
      .builder()
      .optionallyWith(
        cloudWatchMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchMetrics)
      .optionallyWith(
        performanceInsightsMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.performanceInsightsMetrics)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly =
    zio.aws.devopsguru.model.AnomalySourceDetails.wrap(buildAwsValue())
}
object AnomalySourceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AnomalySourceDetails =
      zio.aws.devopsguru.model.AnomalySourceDetails(
        cloudWatchMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        performanceInsightsMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudWatchMetrics: Optional[
      List[zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly]
    ]
    def performanceInsightsMetrics: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly]
    ]
    def getCloudWatchMetrics: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("cloudWatchMetrics", cloudWatchMetrics)
    def getPerformanceInsightsMetrics: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "performanceInsightsMetrics",
      performanceInsightsMetrics
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails
  ) extends zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly {
    override val cloudWatchMetrics: Optional[
      List[zio.aws.devopsguru.model.CloudWatchMetricsDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.CloudWatchMetricsDetail.wrap(item)
        }.toList
      )
    override val performanceInsightsMetrics: Optional[
      List[zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.performanceInsightsMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.PerformanceInsightsMetricsDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AnomalySourceDetails
  ): zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly = new Wrapper(impl)
}
