package zio.aws.devopsguru.model
import scala.jdk.CollectionConverters._
sealed trait OptInStatus {
  def unwrap: software.amazon.awssdk.services.devopsguru.model.OptInStatus
}
object OptInStatus {
  def wrap(
      value: software.amazon.awssdk.services.devopsguru.model.OptInStatus
  ): zio.aws.devopsguru.model.OptInStatus = value match {
    case software.amazon.awssdk.services.devopsguru.model.OptInStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.devopsguru.model.OptInStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.devopsguru.model.OptInStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.devopsguru.model.OptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.OptInStatus =
      software.amazon.awssdk.services.devopsguru.model.OptInStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.devopsguru.model.OptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.OptInStatus =
      software.amazon.awssdk.services.devopsguru.model.OptInStatus.ENABLED
  }
  case object DISABLED extends zio.aws.devopsguru.model.OptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.devopsguru.model.OptInStatus =
      software.amazon.awssdk.services.devopsguru.model.OptInStatus.DISABLED
  }
}
