package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceCollectionResponse(
    resourceCollection: Optional[
      zio.aws.devopsguru.model.ResourceCollectionFilter
    ] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse = {
    import GetResourceCollectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse
      .builder()
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly =
    zio.aws.devopsguru.model.GetResourceCollectionResponse.wrap(buildAwsValue())
}
object GetResourceCollectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.GetResourceCollectionResponse =
      zio.aws.devopsguru.model.GetResourceCollectionResponse(
        resourceCollection.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollectionFilter.ReadOnly]
    def nextToken: Optional[UuidNextToken]
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse
  ) extends zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly {
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollectionFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value =>
          zio.aws.devopsguru.model.ResourceCollectionFilter.wrap(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.GetResourceCollectionResponse
  ): zio.aws.devopsguru.model.GetResourceCollectionResponse.ReadOnly =
    new Wrapper(impl)
}
