package zio.aws.devopsguru.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  Explanation,
  NumberOfLogLinesOccurrences,
  Timestamp,
  LogEventId,
  LogAnomalyToken,
  LogStreamName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LogAnomalyClass(
    logStreamName: Optional[LogStreamName] = Optional.Absent,
    logAnomalyType: Optional[zio.aws.devopsguru.model.LogAnomalyType] =
      Optional.Absent,
    logAnomalyToken: Optional[LogAnomalyToken] = Optional.Absent,
    logEventId: Optional[LogEventId] = Optional.Absent,
    explanation: Optional[Explanation] = Optional.Absent,
    numberOfLogLinesOccurrences: Optional[NumberOfLogLinesOccurrences] =
      Optional.Absent,
    logEventTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass = {
    import LogAnomalyClass.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass
      .builder()
      .optionallyWith(
        logStreamName.map(value =>
          LogStreamName.unwrap(value): java.lang.String
        )
      )(_.logStreamName)
      .optionallyWith(logAnomalyType.map(value => value.unwrap))(
        _.logAnomalyType
      )
      .optionallyWith(
        logAnomalyToken.map(value =>
          LogAnomalyToken.unwrap(value): java.lang.String
        )
      )(_.logAnomalyToken)
      .optionallyWith(
        logEventId.map(value => LogEventId.unwrap(value): java.lang.String)
      )(_.logEventId)
      .optionallyWith(
        explanation.map(value => Explanation.unwrap(value): java.lang.String)
      )(_.explanation)
      .optionallyWith(
        numberOfLogLinesOccurrences.map(value =>
          NumberOfLogLinesOccurrences.unwrap(value): Integer
        )
      )(_.numberOfLogLinesOccurrences)
      .optionallyWith(
        logEventTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.logEventTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.LogAnomalyClass.ReadOnly =
    zio.aws.devopsguru.model.LogAnomalyClass.wrap(buildAwsValue())
}
object LogAnomalyClass {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.LogAnomalyClass =
      zio.aws.devopsguru.model.LogAnomalyClass(
        logStreamName.map(value => value),
        logAnomalyType.map(value => value),
        logAnomalyToken.map(value => value),
        logEventId.map(value => value),
        explanation.map(value => value),
        numberOfLogLinesOccurrences.map(value => value),
        logEventTimestamp.map(value => value)
      )
    def logStreamName: Optional[LogStreamName]
    def logAnomalyType: Optional[zio.aws.devopsguru.model.LogAnomalyType]
    def logAnomalyToken: Optional[LogAnomalyToken]
    def logEventId: Optional[LogEventId]
    def explanation: Optional[Explanation]
    def numberOfLogLinesOccurrences: Optional[NumberOfLogLinesOccurrences]
    def logEventTimestamp: Optional[Timestamp]
    def getLogStreamName: ZIO[Any, AwsError, LogStreamName] =
      AwsError.unwrapOptionField("logStreamName", logStreamName)
    def getLogAnomalyType
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.LogAnomalyType] =
      AwsError.unwrapOptionField("logAnomalyType", logAnomalyType)
    def getLogAnomalyToken: ZIO[Any, AwsError, LogAnomalyToken] =
      AwsError.unwrapOptionField("logAnomalyToken", logAnomalyToken)
    def getLogEventId: ZIO[Any, AwsError, LogEventId] =
      AwsError.unwrapOptionField("logEventId", logEventId)
    def getExplanation: ZIO[Any, AwsError, Explanation] =
      AwsError.unwrapOptionField("explanation", explanation)
    def getNumberOfLogLinesOccurrences
        : ZIO[Any, AwsError, NumberOfLogLinesOccurrences] =
      AwsError.unwrapOptionField(
        "numberOfLogLinesOccurrences",
        numberOfLogLinesOccurrences
      )
    def getLogEventTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("logEventTimestamp", logEventTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass
  ) extends zio.aws.devopsguru.model.LogAnomalyClass.ReadOnly {
    override val logStreamName: Optional[LogStreamName] = zio.aws.core.internal
      .optionalFromNullable(impl.logStreamName())
      .map(value => zio.aws.devopsguru.model.primitives.LogStreamName(value))
    override val logAnomalyType
        : Optional[zio.aws.devopsguru.model.LogAnomalyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logAnomalyType())
        .map(value => zio.aws.devopsguru.model.LogAnomalyType.wrap(value))
    override val logAnomalyToken: Optional[LogAnomalyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logAnomalyToken())
        .map(value =>
          zio.aws.devopsguru.model.primitives.LogAnomalyToken(value)
        )
    override val logEventId: Optional[LogEventId] = zio.aws.core.internal
      .optionalFromNullable(impl.logEventId())
      .map(value => zio.aws.devopsguru.model.primitives.LogEventId(value))
    override val explanation: Optional[Explanation] = zio.aws.core.internal
      .optionalFromNullable(impl.explanation())
      .map(value => zio.aws.devopsguru.model.primitives.Explanation(value))
    override val numberOfLogLinesOccurrences
        : Optional[NumberOfLogLinesOccurrences] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfLogLinesOccurrences())
      .map(value =>
        zio.aws.devopsguru.model.primitives.NumberOfLogLinesOccurrences(value)
      )
    override val logEventTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.logEventTimestamp())
      .map(value => zio.aws.devopsguru.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass
  ): zio.aws.devopsguru.model.LogAnomalyClass.ReadOnly = new Wrapper(impl)
}
