package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.StackName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CloudFormationCostEstimationResourceCollectionFilter(
    stackNames: Optional[Iterable[StackName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter = {
    import CloudFormationCostEstimationResourceCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
      .builder()
      .optionallyWith(
        stackNames.map(value =>
          value.map { item =>
            StackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.stackNames)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
      .wrap(buildAwsValue())
}
object CloudFormationCostEstimationResourceCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter =
      zio.aws.devopsguru.model
        .CloudFormationCostEstimationResourceCollectionFilter(
          stackNames.map(value => value)
        )
    def stackNames: Optional[List[StackName]]
    def getStackNames: ZIO[Any, AwsError, List[StackName]] =
      AwsError.unwrapOptionField("stackNames", stackNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
  ) extends zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.ReadOnly {
    override val stackNames: Optional[List[StackName]] = zio.aws.core.internal
      .optionalFromNullable(impl.stackNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.primitives.StackName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter
  ): zio.aws.devopsguru.model.CloudFormationCostEstimationResourceCollectionFilter.ReadOnly =
    new Wrapper(impl)
}
