package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{UuidNextToken, Cost}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetCostEstimationResponse(
    resourceCollection: Optional[
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter
    ] = Optional.Absent,
    status: Optional[zio.aws.devopsguru.model.CostEstimationStatus] =
      Optional.Absent,
    costs: Optional[Iterable[zio.aws.devopsguru.model.ServiceResourceCost]] =
      Optional.Absent,
    timeRange: Optional[zio.aws.devopsguru.model.CostEstimationTimeRange] =
      Optional.Absent,
    totalCost: Optional[Cost] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse = {
    import GetCostEstimationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse
      .builder()
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        costs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.costs)
      .optionallyWith(timeRange.map(value => value.buildAwsValue()))(
        _.timeRange
      )
      .optionallyWith(
        totalCost.map(value => Cost.unwrap(value): java.lang.Double)
      )(_.totalCost)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly =
    zio.aws.devopsguru.model.GetCostEstimationResponse.wrap(buildAwsValue())
}
object GetCostEstimationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.GetCostEstimationResponse =
      zio.aws.devopsguru.model.GetCostEstimationResponse(
        resourceCollection.map(value => value.asEditable),
        status.map(value => value),
        costs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timeRange.map(value => value.asEditable),
        totalCost.map(value => value),
        nextToken.map(value => value)
      )
    def resourceCollection: Optional[
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly
    ]
    def status: Optional[zio.aws.devopsguru.model.CostEstimationStatus]
    def costs
        : Optional[List[zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly]]
    def timeRange
        : Optional[zio.aws.devopsguru.model.CostEstimationTimeRange.ReadOnly]
    def totalCost: Optional[Cost]
    def nextToken: Optional[UuidNextToken]
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.CostEstimationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCosts: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly
    ]] = AwsError.unwrapOptionField("costs", costs)
    def getTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.CostEstimationTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("timeRange", timeRange)
    def getTotalCost: ZIO[Any, AwsError, Cost] =
      AwsError.unwrapOptionField("totalCost", totalCost)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse
  ) extends zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly {
    override val resourceCollection: Optional[
      zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceCollection())
      .map(value =>
        zio.aws.devopsguru.model.CostEstimationResourceCollectionFilter
          .wrap(value)
      )
    override val status
        : Optional[zio.aws.devopsguru.model.CostEstimationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.devopsguru.model.CostEstimationStatus.wrap(value))
    override val costs: Optional[
      List[zio.aws.devopsguru.model.ServiceResourceCost.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.costs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ServiceResourceCost.wrap(item)
        }.toList
      )
    override val timeRange
        : Optional[zio.aws.devopsguru.model.CostEstimationTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeRange())
        .map(value =>
          zio.aws.devopsguru.model.CostEstimationTimeRange.wrap(value)
        )
    override val totalCost: Optional[Cost] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCost())
      .map(value => zio.aws.devopsguru.model.primitives.Cost(value))
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.GetCostEstimationResponse
  ): zio.aws.devopsguru.model.GetCostEstimationResponse.ReadOnly = new Wrapper(
    impl
  )
}
