package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  PerformanceInsightsMetricLimitInteger,
  PerformanceInsightsMetricDimension,
  PerformanceInsightsMetricGroup
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class PerformanceInsightsMetricDimensionGroup(
    group: Optional[PerformanceInsightsMetricGroup] = Optional.Absent,
    dimensions: Optional[Iterable[PerformanceInsightsMetricDimension]] =
      Optional.Absent,
    limit: Optional[PerformanceInsightsMetricLimitInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup = {
    import PerformanceInsightsMetricDimensionGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
      .builder()
      .optionallyWith(
        group.map(value =>
          PerformanceInsightsMetricGroup.unwrap(value): java.lang.String
        )
      )(_.group)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            PerformanceInsightsMetricDimension.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dimensions)
      .optionallyWith(
        limit.map(value =>
          PerformanceInsightsMetricLimitInteger.unwrap(value): Integer
        )
      )(_.limit)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly =
    zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup
      .wrap(buildAwsValue())
}
object PerformanceInsightsMetricDimensionGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup =
      zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup(
        group.map(value => value),
        dimensions.map(value => value),
        limit.map(value => value)
      )
    def group: Optional[PerformanceInsightsMetricGroup]
    def dimensions: Optional[List[PerformanceInsightsMetricDimension]]
    def limit: Optional[PerformanceInsightsMetricLimitInteger]
    def getGroup: ZIO[Any, AwsError, PerformanceInsightsMetricGroup] =
      AwsError.unwrapOptionField("group", group)
    def getDimensions
        : ZIO[Any, AwsError, List[PerformanceInsightsMetricDimension]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getLimit: ZIO[Any, AwsError, PerformanceInsightsMetricLimitInteger] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
  ) extends zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly {
    override val group: Optional[PerformanceInsightsMetricGroup] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .PerformanceInsightsMetricGroup(value)
        )
    override val dimensions
        : Optional[List[PerformanceInsightsMetricDimension]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives
              .PerformanceInsightsMetricDimension(item)
          }.toList
        )
    override val limit: Optional[PerformanceInsightsMetricLimitInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .PerformanceInsightsMetricLimitInteger(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.PerformanceInsightsMetricDimensionGroup
  ): zio.aws.devopsguru.model.PerformanceInsightsMetricDimensionGroup.ReadOnly =
    new Wrapper(impl)
}
