package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnomaliesForInsightResponse(
    proactiveAnomalies: Optional[
      Iterable[zio.aws.devopsguru.model.ProactiveAnomalySummary]
    ] = Optional.Absent,
    reactiveAnomalies: Optional[
      Iterable[zio.aws.devopsguru.model.ReactiveAnomalySummary]
    ] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse = {
    import ListAnomaliesForInsightResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse
      .builder()
      .optionallyWith(
        proactiveAnomalies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proactiveAnomalies)
      .optionallyWith(
        reactiveAnomalies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reactiveAnomalies)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly =
    zio.aws.devopsguru.model.ListAnomaliesForInsightResponse
      .wrap(buildAwsValue())
}
object ListAnomaliesForInsightResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListAnomaliesForInsightResponse =
      zio.aws.devopsguru.model.ListAnomaliesForInsightResponse(
        proactiveAnomalies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reactiveAnomalies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proactiveAnomalies: Optional[
      List[zio.aws.devopsguru.model.ProactiveAnomalySummary.ReadOnly]
    ]
    def reactiveAnomalies: Optional[
      List[zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly]
    ]
    def nextToken: Optional[UuidNextToken]
    def getProactiveAnomalies: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ProactiveAnomalySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("proactiveAnomalies", proactiveAnomalies)
    def getReactiveAnomalies: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("reactiveAnomalies", reactiveAnomalies)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse
  ) extends zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly {
    override val proactiveAnomalies: Optional[
      List[zio.aws.devopsguru.model.ProactiveAnomalySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proactiveAnomalies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ProactiveAnomalySummary.wrap(item)
        }.toList
      )
    override val reactiveAnomalies: Optional[
      List[zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reactiveAnomalies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ReactiveAnomalySummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightResponse
  ): zio.aws.devopsguru.model.ListAnomaliesForInsightResponse.ReadOnly =
    new Wrapper(impl)
}
