package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  UuidNextToken,
  OrganizationalUnitId,
  AwsAccountId,
  ListInsightsMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListOrganizationInsightsRequest(
    statusFilter: zio.aws.devopsguru.model.ListInsightsStatusFilter,
    maxResults: Optional[ListInsightsMaxResults] = Optional.Absent,
    accountIds: Optional[Iterable[AwsAccountId]] = Optional.Absent,
    organizationalUnitIds: Optional[Iterable[OrganizationalUnitId]] =
      Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest = {
    import ListOrganizationInsightsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest
      .builder()
      .statusFilter(statusFilter.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => ListInsightsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        accountIds.map(value =>
          value.map { item =>
            AwsAccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accountIds)
      .optionallyWith(
        organizationalUnitIds.map(value =>
          value.map { item =>
            OrganizationalUnitId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationalUnitIds)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListOrganizationInsightsRequest.ReadOnly =
    zio.aws.devopsguru.model.ListOrganizationInsightsRequest
      .wrap(buildAwsValue())
}
object ListOrganizationInsightsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListOrganizationInsightsRequest =
      zio.aws.devopsguru.model.ListOrganizationInsightsRequest(
        statusFilter.asEditable,
        maxResults.map(value => value),
        accountIds.map(value => value),
        organizationalUnitIds.map(value => value),
        nextToken.map(value => value)
      )
    def statusFilter: zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly
    def maxResults: Optional[ListInsightsMaxResults]
    def accountIds: Optional[List[AwsAccountId]]
    def organizationalUnitIds: Optional[List[OrganizationalUnitId]]
    def nextToken: Optional[UuidNextToken]
    def getStatusFilter: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly
    ] = ZIO.succeed(statusFilter)
    def getMaxResults: ZIO[Any, AwsError, ListInsightsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAccountIds: ZIO[Any, AwsError, List[AwsAccountId]] =
      AwsError.unwrapOptionField("accountIds", accountIds)
    def getOrganizationalUnitIds
        : ZIO[Any, AwsError, List[OrganizationalUnitId]] =
      AwsError.unwrapOptionField("organizationalUnitIds", organizationalUnitIds)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest
  ) extends zio.aws.devopsguru.model.ListOrganizationInsightsRequest.ReadOnly {
    override val statusFilter
        : zio.aws.devopsguru.model.ListInsightsStatusFilter.ReadOnly =
      zio.aws.devopsguru.model.ListInsightsStatusFilter
        .wrap(impl.statusFilter())
    override val maxResults: Optional[ListInsightsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives.ListInsightsMaxResults(value)
        )
    override val accountIds: Optional[List[AwsAccountId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives.AwsAccountId(item)
          }.toList
        )
    override val organizationalUnitIds: Optional[List[OrganizationalUnitId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.primitives.OrganizationalUnitId(item)
          }.toList
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsRequest
  ): zio.aws.devopsguru.model.ListOrganizationInsightsRequest.ReadOnly =
    new Wrapper(impl)
}
