package zio.aws.devopsguru.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.devopsguru.model.primitives.{
  AwsAccountId,
  UuidNextToken,
  ListEventsMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEventsRequest(
    filters: zio.aws.devopsguru.model.ListEventsFilters,
    maxResults: Optional[ListEventsMaxResults] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent,
    accountId: Optional[AwsAccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListEventsRequest = {
    import ListEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListEventsRequest
      .builder()
      .filters(filters.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => ListEventsMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListEventsRequest.ReadOnly =
    zio.aws.devopsguru.model.ListEventsRequest.wrap(buildAwsValue())
}
object ListEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListEventsRequest =
      zio.aws.devopsguru.model.ListEventsRequest(
        filters.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value),
        accountId.map(value => value)
      )
    def filters: zio.aws.devopsguru.model.ListEventsFilters.ReadOnly
    def maxResults: Optional[ListEventsMaxResults]
    def nextToken: Optional[UuidNextToken]
    def accountId: Optional[AwsAccountId]
    def getFilters: ZIO[
      Any,
      Nothing,
      zio.aws.devopsguru.model.ListEventsFilters.ReadOnly
    ] = ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, ListEventsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListEventsRequest
  ) extends zio.aws.devopsguru.model.ListEventsRequest.ReadOnly {
    override val filters: zio.aws.devopsguru.model.ListEventsFilters.ReadOnly =
      zio.aws.devopsguru.model.ListEventsFilters.wrap(impl.filters())
    override val maxResults: Optional[ListEventsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.devopsguru.model.primitives.ListEventsMaxResults(value)
        )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
    override val accountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListEventsRequest
  ): zio.aws.devopsguru.model.ListEventsRequest.ReadOnly = new Wrapper(impl)
}
