package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  InsightDescription,
  SsmOpsItemId,
  InsightName,
  InsightId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ProactiveInsight(
    id: Option[InsightId] = None,
    name: Option[InsightName] = None,
    severity: Option[zio.aws.devopsguru.model.InsightSeverity] = None,
    status: Option[zio.aws.devopsguru.model.InsightStatus] = None,
    insightTimeRange: Option[zio.aws.devopsguru.model.InsightTimeRange] = None,
    predictionTimeRange: Option[zio.aws.devopsguru.model.PredictionTimeRange] =
      None,
    resourceCollection: Option[zio.aws.devopsguru.model.ResourceCollection] =
      None,
    ssmOpsItemId: Option[SsmOpsItemId] = None,
    description: Option[InsightDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ProactiveInsight = {
    import ProactiveInsight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
      .builder()
      .optionallyWith(
        id.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => InsightName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(insightTimeRange.map(value => value.buildAwsValue()))(
        _.insightTimeRange
      )
      .optionallyWith(predictionTimeRange.map(value => value.buildAwsValue()))(
        _.predictionTimeRange
      )
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(
        ssmOpsItemId.map(value => SsmOpsItemId.unwrap(value): java.lang.String)
      )(_.ssmOpsItemId)
      .optionallyWith(
        description.map(value =>
          InsightDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ProactiveInsight.ReadOnly =
    zio.aws.devopsguru.model.ProactiveInsight.wrap(buildAwsValue())
}
object ProactiveInsight {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ProactiveInsight =
      zio.aws.devopsguru.model.ProactiveInsight(
        id.map(value => value),
        name.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        insightTimeRange.map(value => value.asEditable),
        predictionTimeRange.map(value => value.asEditable),
        resourceCollection.map(value => value.asEditable),
        ssmOpsItemId.map(value => value),
        description.map(value => value)
      )
    def id: Option[InsightId]
    def name: Option[InsightName]
    def severity: Option[zio.aws.devopsguru.model.InsightSeverity]
    def status: Option[zio.aws.devopsguru.model.InsightStatus]
    def insightTimeRange
        : Option[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly]
    def predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly]
    def resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def ssmOpsItemId: Option[SsmOpsItemId]
    def description: Option[InsightDescription]
    def getId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, InsightName] =
      AwsError.unwrapOptionField("name", name)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightSeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightStatus] =
      AwsError.unwrapOptionField("status", status)
    def getInsightTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.InsightTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("insightTimeRange", insightTimeRange)
    def getPredictionTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("predictionTimeRange", predictionTimeRange)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getSsmOpsItemId: ZIO[Any, AwsError, SsmOpsItemId] =
      AwsError.unwrapOptionField("ssmOpsItemId", ssmOpsItemId)
    def getDescription: ZIO[Any, AwsError, InsightDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
  ) extends zio.aws.devopsguru.model.ProactiveInsight.ReadOnly {
    override val id: Option[InsightId] = scala
      .Option(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val name: Option[InsightName] = scala
      .Option(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.InsightName(value))
    override val severity: Option[zio.aws.devopsguru.model.InsightSeverity] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.devopsguru.model.InsightSeverity.wrap(value))
    override val status: Option[zio.aws.devopsguru.model.InsightStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devopsguru.model.InsightStatus.wrap(value))
    override val insightTimeRange
        : Option[zio.aws.devopsguru.model.InsightTimeRange.ReadOnly] = scala
      .Option(impl.insightTimeRange())
      .map(value => zio.aws.devopsguru.model.InsightTimeRange.wrap(value))
    override val predictionTimeRange
        : Option[zio.aws.devopsguru.model.PredictionTimeRange.ReadOnly] = scala
      .Option(impl.predictionTimeRange())
      .map(value => zio.aws.devopsguru.model.PredictionTimeRange.wrap(value))
    override val resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] = scala
      .Option(impl.resourceCollection())
      .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val ssmOpsItemId: Option[SsmOpsItemId] = scala
      .Option(impl.ssmOpsItemId())
      .map(value => zio.aws.devopsguru.model.primitives.SsmOpsItemId(value))
    override val description: Option[InsightDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.devopsguru.model.primitives.InsightDescription(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ProactiveInsight
  ): zio.aws.devopsguru.model.ProactiveInsight.ReadOnly = new Wrapper(impl)
}
