package zio.aws.devopsguru.model
import java.lang.Integer
import zio.aws.devopsguru.model.primitives.{
  NumOpenReactiveInsights,
  NumOpenProactiveInsights
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccountInsightHealth(
    openProactiveInsights: Option[NumOpenProactiveInsights] = None,
    openReactiveInsights: Option[NumOpenReactiveInsights] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.AccountInsightHealth = {
    import AccountInsightHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.AccountInsightHealth
      .builder()
      .optionallyWith(
        openProactiveInsights.map(value =>
          NumOpenProactiveInsights.unwrap(value): Integer
        )
      )(_.openProactiveInsights)
      .optionallyWith(
        openReactiveInsights.map(value =>
          NumOpenReactiveInsights.unwrap(value): Integer
        )
      )(_.openReactiveInsights)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.AccountInsightHealth.ReadOnly =
    zio.aws.devopsguru.model.AccountInsightHealth.wrap(buildAwsValue())
}
object AccountInsightHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.AccountInsightHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.AccountInsightHealth =
      zio.aws.devopsguru.model.AccountInsightHealth(
        openProactiveInsights.map(value => value),
        openReactiveInsights.map(value => value)
      )
    def openProactiveInsights: Option[NumOpenProactiveInsights]
    def openReactiveInsights: Option[NumOpenReactiveInsights]
    def getOpenProactiveInsights: ZIO[Any, AwsError, NumOpenProactiveInsights] =
      AwsError.unwrapOptionField("openProactiveInsights", openProactiveInsights)
    def getOpenReactiveInsights: ZIO[Any, AwsError, NumOpenReactiveInsights] =
      AwsError.unwrapOptionField("openReactiveInsights", openReactiveInsights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.AccountInsightHealth
  ) extends zio.aws.devopsguru.model.AccountInsightHealth.ReadOnly {
    override val openProactiveInsights: Option[NumOpenProactiveInsights] = scala
      .Option(impl.openProactiveInsights())
      .map(value =>
        zio.aws.devopsguru.model.primitives.NumOpenProactiveInsights(value)
      )
    override val openReactiveInsights: Option[NumOpenReactiveInsights] = scala
      .Option(impl.openReactiveInsights())
      .map(value =>
        zio.aws.devopsguru.model.primitives.NumOpenReactiveInsights(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.AccountInsightHealth
  ): zio.aws.devopsguru.model.AccountInsightHealth.ReadOnly = new Wrapper(impl)
}
