package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  AnomalyDescription,
  AnomalyName,
  InsightId,
  AnomalyId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ReactiveAnomalySummary(
    id: Option[AnomalyId] = None,
    severity: Option[zio.aws.devopsguru.model.AnomalySeverity] = None,
    status: Option[zio.aws.devopsguru.model.AnomalyStatus] = None,
    anomalyTimeRange: Option[zio.aws.devopsguru.model.AnomalyTimeRange] = None,
    anomalyReportedTimeRange: Option[
      zio.aws.devopsguru.model.AnomalyReportedTimeRange
    ] = None,
    sourceDetails: Option[zio.aws.devopsguru.model.AnomalySourceDetails] = None,
    associatedInsightId: Option[InsightId] = None,
    resourceCollection: Option[zio.aws.devopsguru.model.ResourceCollection] =
      None,
    `type`: Option[zio.aws.devopsguru.model.AnomalyType] = None,
    name: Option[AnomalyName] = None,
    description: Option[AnomalyDescription] = None,
    causalAnomalyId: Option[AnomalyId] = None,
    anomalyResources: Option[
      Iterable[zio.aws.devopsguru.model.AnomalyResource]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary = {
    import ReactiveAnomalySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary
      .builder()
      .optionallyWith(
        id.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(severity.map(value => value.unwrap))(_.severity)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(anomalyTimeRange.map(value => value.buildAwsValue()))(
        _.anomalyTimeRange
      )
      .optionallyWith(
        anomalyReportedTimeRange.map(value => value.buildAwsValue())
      )(_.anomalyReportedTimeRange)
      .optionallyWith(sourceDetails.map(value => value.buildAwsValue()))(
        _.sourceDetails
      )
      .optionallyWith(
        associatedInsightId.map(value =>
          InsightId.unwrap(value): java.lang.String
        )
      )(_.associatedInsightId)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => AnomalyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AnomalyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        causalAnomalyId.map(value => AnomalyId.unwrap(value): java.lang.String)
      )(_.causalAnomalyId)
      .optionallyWith(
        anomalyResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.anomalyResources)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly =
    zio.aws.devopsguru.model.ReactiveAnomalySummary.wrap(buildAwsValue())
}
object ReactiveAnomalySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ReactiveAnomalySummary =
      zio.aws.devopsguru.model.ReactiveAnomalySummary(
        id.map(value => value),
        severity.map(value => value),
        status.map(value => value),
        anomalyTimeRange.map(value => value.asEditable),
        anomalyReportedTimeRange.map(value => value.asEditable),
        sourceDetails.map(value => value.asEditable),
        associatedInsightId.map(value => value),
        resourceCollection.map(value => value.asEditable),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        causalAnomalyId.map(value => value),
        anomalyResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Option[AnomalyId]
    def severity: Option[zio.aws.devopsguru.model.AnomalySeverity]
    def status: Option[zio.aws.devopsguru.model.AnomalyStatus]
    def anomalyTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly]
    def anomalyReportedTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly]
    def sourceDetails
        : Option[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly]
    def associatedInsightId: Option[InsightId]
    def resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def `type`: Option[zio.aws.devopsguru.model.AnomalyType]
    def name: Option[AnomalyName]
    def description: Option[AnomalyDescription]
    def causalAnomalyId: Option[AnomalyId]
    def anomalyResources
        : Option[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]]
    def getId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("id", id)
    def getSeverity
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalySeverity] =
      AwsError.unwrapOptionField("severity", severity)
    def getStatus: ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAnomalyTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField("anomalyTimeRange", anomalyTimeRange)
    def getAnomalyReportedTimeRange: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly
    ] = AwsError.unwrapOptionField(
      "anomalyReportedTimeRange",
      anomalyReportedTimeRange
    )
    def getSourceDetails: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly
    ] = AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getAssociatedInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("associatedInsightId", associatedInsightId)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
    def getType: ZIO[Any, AwsError, zio.aws.devopsguru.model.AnomalyType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, AnomalyName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AnomalyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCausalAnomalyId: ZIO[Any, AwsError, AnomalyId] =
      AwsError.unwrapOptionField("causalAnomalyId", causalAnomalyId)
    def getAnomalyResources: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.AnomalyResource.ReadOnly
    ]] = AwsError.unwrapOptionField("anomalyResources", anomalyResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary
  ) extends zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly {
    override val id: Option[AnomalyId] = scala
      .Option(impl.id())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
    override val severity: Option[zio.aws.devopsguru.model.AnomalySeverity] =
      scala
        .Option(impl.severity())
        .map(value => zio.aws.devopsguru.model.AnomalySeverity.wrap(value))
    override val status: Option[zio.aws.devopsguru.model.AnomalyStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.devopsguru.model.AnomalyStatus.wrap(value))
    override val anomalyTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyTimeRange.ReadOnly] = scala
      .Option(impl.anomalyTimeRange())
      .map(value => zio.aws.devopsguru.model.AnomalyTimeRange.wrap(value))
    override val anomalyReportedTimeRange
        : Option[zio.aws.devopsguru.model.AnomalyReportedTimeRange.ReadOnly] =
      scala
        .Option(impl.anomalyReportedTimeRange())
        .map(value =>
          zio.aws.devopsguru.model.AnomalyReportedTimeRange.wrap(value)
        )
    override val sourceDetails
        : Option[zio.aws.devopsguru.model.AnomalySourceDetails.ReadOnly] = scala
      .Option(impl.sourceDetails())
      .map(value => zio.aws.devopsguru.model.AnomalySourceDetails.wrap(value))
    override val associatedInsightId: Option[InsightId] = scala
      .Option(impl.associatedInsightId())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val resourceCollection
        : Option[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] = scala
      .Option(impl.resourceCollection())
      .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
    override val `type`: Option[zio.aws.devopsguru.model.AnomalyType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.devopsguru.model.AnomalyType.wrap(value))
    override val name: Option[AnomalyName] = scala
      .Option(impl.name())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyName(value))
    override val description: Option[AnomalyDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.devopsguru.model.primitives.AnomalyDescription(value)
      )
    override val causalAnomalyId: Option[AnomalyId] = scala
      .Option(impl.causalAnomalyId())
      .map(value => zio.aws.devopsguru.model.primitives.AnomalyId(value))
    override val anomalyResources
        : Option[List[zio.aws.devopsguru.model.AnomalyResource.ReadOnly]] =
      scala
        .Option(impl.anomalyResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.AnomalyResource.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ReactiveAnomalySummary
  ): zio.aws.devopsguru.model.ReactiveAnomalySummary.ReadOnly = new Wrapper(
    impl
  )
}
