package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListNotificationChannelsResponse(
    channels: Option[Iterable[zio.aws.devopsguru.model.NotificationChannel]] =
      None,
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse = {
    import ListNotificationChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse
      .builder()
      .optionallyWith(
        channels.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.channels)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly =
    zio.aws.devopsguru.model.ListNotificationChannelsResponse
      .wrap(buildAwsValue())
}
object ListNotificationChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListNotificationChannelsResponse =
      zio.aws.devopsguru.model.ListNotificationChannelsResponse(
        channels.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def channels
        : Option[List[zio.aws.devopsguru.model.NotificationChannel.ReadOnly]]
    def nextToken: Option[UuidNextToken]
    def getChannels: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.NotificationChannel.ReadOnly
    ]] = AwsError.unwrapOptionField("channels", channels)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse
  ) extends zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly {
    override val channels
        : Option[List[zio.aws.devopsguru.model.NotificationChannel.ReadOnly]] =
      scala
        .Option(impl.channels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.devopsguru.model.NotificationChannel.wrap(item)
          }.toList
        )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListNotificationChannelsResponse
  ): zio.aws.devopsguru.model.ListNotificationChannelsResponse.ReadOnly =
    new Wrapper(impl)
}
