package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecommendationRelatedAnomalySourceDetail(
    cloudWatchMetrics: Option[Iterable[
      zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalySourceDetail = {
    import RecommendationRelatedAnomalySourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalySourceDetail
      .builder()
      .optionallyWith(
        cloudWatchMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchMetrics)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail
      .wrap(buildAwsValue())
}
object RecommendationRelatedAnomalySourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalySourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail =
      zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail(
        cloudWatchMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudWatchMetrics: Option[List[
      zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly
    ]]
    def getCloudWatchMetrics: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("cloudWatchMetrics", cloudWatchMetrics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalySourceDetail
  ) extends zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly {
    override val cloudWatchMetrics: Option[List[
      zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly
    ]] = scala
      .Option(impl.cloudWatchMetrics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedAnomalySourceDetail
  ): zio.aws.devopsguru.model.RecommendationRelatedAnomalySourceDetail.ReadOnly =
    new Wrapper(impl)
}
