package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListOrganizationInsightsResponse(
    proactiveInsights: Option[
      Iterable[zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary]
    ] = None,
    reactiveInsights: Option[
      Iterable[zio.aws.devopsguru.model.ReactiveOrganizationInsightSummary]
    ] = None,
    nextToken: Option[UuidNextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse = {
    import ListOrganizationInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse
      .builder()
      .optionallyWith(
        proactiveInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proactiveInsights)
      .optionallyWith(
        reactiveInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reactiveInsights)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly =
    zio.aws.devopsguru.model.ListOrganizationInsightsResponse
      .wrap(buildAwsValue())
}
object ListOrganizationInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListOrganizationInsightsResponse =
      zio.aws.devopsguru.model.ListOrganizationInsightsResponse(
        proactiveInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reactiveInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proactiveInsights: Option[List[
      zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
    ]]
    def reactiveInsights: Option[
      List[zio.aws.devopsguru.model.ReactiveOrganizationInsightSummary.ReadOnly]
    ]
    def nextToken: Option[UuidNextToken]
    def getProactiveInsights: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("proactiveInsights", proactiveInsights)
    def getReactiveInsights: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ReactiveOrganizationInsightSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("reactiveInsights", reactiveInsights)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse
  ) extends zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly {
    override val proactiveInsights: Option[List[
      zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary.ReadOnly
    ]] = scala
      .Option(impl.proactiveInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ProactiveOrganizationInsightSummary
            .wrap(item)
        }.toList
      )
    override val reactiveInsights: Option[
      List[zio.aws.devopsguru.model.ReactiveOrganizationInsightSummary.ReadOnly]
    ] = scala
      .Option(impl.reactiveInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ReactiveOrganizationInsightSummary.wrap(item)
        }.toList
      )
    override val nextToken: Option[UuidNextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListOrganizationInsightsResponse
  ): zio.aws.devopsguru.model.ListOrganizationInsightsResponse.ReadOnly =
    new Wrapper(impl)
}
