package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.NotificationChannelId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotificationChannel(
    id: Option[NotificationChannelId] = None,
    config: Option[zio.aws.devopsguru.model.NotificationChannelConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.NotificationChannel = {
    import NotificationChannel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.NotificationChannel
      .builder()
      .optionallyWith(
        id.map(value => NotificationChannelId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(config.map(value => value.buildAwsValue()))(_.config)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.NotificationChannel.ReadOnly =
    zio.aws.devopsguru.model.NotificationChannel.wrap(buildAwsValue())
}
object NotificationChannel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.NotificationChannel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.NotificationChannel =
      zio.aws.devopsguru.model.NotificationChannel(
        id.map(value => value),
        config.map(value => value.asEditable)
      )
    def id: Option[NotificationChannelId]
    def config
        : Option[zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly]
    def getId: ZIO[Any, AwsError, NotificationChannelId] =
      AwsError.unwrapOptionField("id", id)
    def getConfig: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly
    ] = AwsError.unwrapOptionField("config", config)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannel
  ) extends zio.aws.devopsguru.model.NotificationChannel.ReadOnly {
    override val id: Option[NotificationChannelId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.devopsguru.model.primitives.NotificationChannelId(value)
      )
    override val config
        : Option[zio.aws.devopsguru.model.NotificationChannelConfig.ReadOnly] =
      scala
        .Option(impl.config())
        .map(value =>
          zio.aws.devopsguru.model.NotificationChannelConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.NotificationChannel
  ): zio.aws.devopsguru.model.NotificationChannel.ReadOnly = new Wrapper(impl)
}
