package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  RecommendationRelatedCloudWatchMetricsSourceNamespace,
  RecommendationRelatedCloudWatchMetricsSourceMetricName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecommendationRelatedCloudWatchMetricsSourceDetail(
    metricName: Optional[
      RecommendationRelatedCloudWatchMetricsSourceMetricName
    ] = Optional.Absent,
    namespace: Optional[RecommendationRelatedCloudWatchMetricsSourceNamespace] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail = {
    import RecommendationRelatedCloudWatchMetricsSourceDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
      .builder()
      .optionallyWith(
        metricName.map(value =>
          RecommendationRelatedCloudWatchMetricsSourceMetricName.unwrap(
            value
          ): java.lang.String
        )
      )(_.metricName)
      .optionallyWith(
        namespace.map(value =>
          RecommendationRelatedCloudWatchMetricsSourceNamespace.unwrap(
            value
          ): java.lang.String
        )
      )(_.namespace)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly =
    zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
      .wrap(buildAwsValue())
}
object RecommendationRelatedCloudWatchMetricsSourceDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail =
      zio.aws.devopsguru.model
        .RecommendationRelatedCloudWatchMetricsSourceDetail(
          metricName.map(value => value),
          namespace.map(value => value)
        )
    def metricName
        : Optional[RecommendationRelatedCloudWatchMetricsSourceMetricName]
    def namespace
        : Optional[RecommendationRelatedCloudWatchMetricsSourceNamespace]
    def getMetricName: ZIO[
      Any,
      AwsError,
      RecommendationRelatedCloudWatchMetricsSourceMetricName
    ] = AwsError.unwrapOptionField("metricName", metricName)
    def getNamespace: ZIO[
      Any,
      AwsError,
      RecommendationRelatedCloudWatchMetricsSourceNamespace
    ] = AwsError.unwrapOptionField("namespace", namespace)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ) extends zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly {
    override val metricName
        : Optional[RecommendationRelatedCloudWatchMetricsSourceMetricName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricName())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .RecommendationRelatedCloudWatchMetricsSourceMetricName(value)
        )
    override val namespace
        : Optional[RecommendationRelatedCloudWatchMetricsSourceNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value =>
          zio.aws.devopsguru.model.primitives
            .RecommendationRelatedCloudWatchMetricsSourceNamespace(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail
  ): zio.aws.devopsguru.model.RecommendationRelatedCloudWatchMetricsSourceDetail.ReadOnly =
    new Wrapper(impl)
}
