package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAnomaliesForInsightFilters(
    serviceCollection: Optional[zio.aws.devopsguru.model.ServiceCollection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightFilters = {
    import ListAnomaliesForInsightFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightFilters
      .builder()
      .optionallyWith(serviceCollection.map(value => value.buildAwsValue()))(
        _.serviceCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.ReadOnly =
    zio.aws.devopsguru.model.ListAnomaliesForInsightFilters
      .wrap(buildAwsValue())
}
object ListAnomaliesForInsightFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListAnomaliesForInsightFilters =
      zio.aws.devopsguru.model.ListAnomaliesForInsightFilters(
        serviceCollection.map(value => value.asEditable)
      )
    def serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly]
    def getServiceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServiceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("serviceCollection", serviceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightFilters
  ) extends zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.ReadOnly {
    override val serviceCollection
        : Optional[zio.aws.devopsguru.model.ServiceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceCollection())
        .map(value => zio.aws.devopsguru.model.ServiceCollection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListAnomaliesForInsightFilters
  ): zio.aws.devopsguru.model.ListAnomaliesForInsightFilters.ReadOnly =
    new Wrapper(impl)
}
