package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.KMSKeyId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KMSServerSideEncryptionIntegrationConfig(
    kmsKeyId: Optional[KMSKeyId] = Optional.Absent,
    optInStatus: Optional[zio.aws.devopsguru.model.OptInStatus] =
      Optional.Absent,
    `type`: Optional[zio.aws.devopsguru.model.ServerSideEncryptionType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.KMSServerSideEncryptionIntegrationConfig = {
    import KMSServerSideEncryptionIntegrationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.KMSServerSideEncryptionIntegrationConfig
      .builder()
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(optInStatus.map(value => value.unwrap))(_.optInStatus)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.KMSServerSideEncryptionIntegrationConfig.ReadOnly =
    zio.aws.devopsguru.model.KMSServerSideEncryptionIntegrationConfig
      .wrap(buildAwsValue())
}
object KMSServerSideEncryptionIntegrationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.KMSServerSideEncryptionIntegrationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.KMSServerSideEncryptionIntegrationConfig =
      zio.aws.devopsguru.model.KMSServerSideEncryptionIntegrationConfig(
        kmsKeyId.map(value => value),
        optInStatus.map(value => value),
        `type`.map(value => value)
      )
    def kmsKeyId: Optional[KMSKeyId]
    def optInStatus: Optional[zio.aws.devopsguru.model.OptInStatus]
    def `type`: Optional[zio.aws.devopsguru.model.ServerSideEncryptionType]
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOptInStatus
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.OptInStatus] =
      AwsError.unwrapOptionField("optInStatus", optInStatus)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ServerSideEncryptionType
    ] = AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.KMSServerSideEncryptionIntegrationConfig
  ) extends zio.aws.devopsguru.model.KMSServerSideEncryptionIntegrationConfig.ReadOnly {
    override val kmsKeyId: Optional[KMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.devopsguru.model.primitives.KMSKeyId(value))
    override val optInStatus: Optional[zio.aws.devopsguru.model.OptInStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optInStatus())
        .map(value => zio.aws.devopsguru.model.OptInStatus.wrap(value))
    override val `type`
        : Optional[zio.aws.devopsguru.model.ServerSideEncryptionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.devopsguru.model.ServerSideEncryptionType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.KMSServerSideEncryptionIntegrationConfig
  ): zio.aws.devopsguru.model.KMSServerSideEncryptionIntegrationConfig.ReadOnly =
    new Wrapper(impl)
}
