package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{TagValue, AppBoundaryKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagCostEstimationResourceCollectionFilter(
    appBoundaryKey: AppBoundaryKey,
    tagValues: Iterable[TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.TagCostEstimationResourceCollectionFilter = {
    import TagCostEstimationResourceCollectionFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.TagCostEstimationResourceCollectionFilter
      .builder()
      .appBoundaryKey(AppBoundaryKey.unwrap(appBoundaryKey): java.lang.String)
      .tagValues(tagValues.map { item =>
        TagValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter.ReadOnly =
    zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter
      .wrap(buildAwsValue())
}
object TagCostEstimationResourceCollectionFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.TagCostEstimationResourceCollectionFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter =
      zio.aws.devopsguru.model
        .TagCostEstimationResourceCollectionFilter(appBoundaryKey, tagValues)
    def appBoundaryKey: AppBoundaryKey
    def tagValues: List[TagValue]
    def getAppBoundaryKey: ZIO[Any, Nothing, AppBoundaryKey] =
      ZIO.succeed(appBoundaryKey)
    def getTagValues: ZIO[Any, Nothing, List[TagValue]] = ZIO.succeed(tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.TagCostEstimationResourceCollectionFilter
  ) extends zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter.ReadOnly {
    override val appBoundaryKey: AppBoundaryKey =
      zio.aws.devopsguru.model.primitives.AppBoundaryKey(impl.appBoundaryKey())
    override val tagValues: List[TagValue] = impl
      .tagValues()
      .asScala
      .map { item =>
        zio.aws.devopsguru.model.primitives.TagValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.TagCostEstimationResourceCollectionFilter
  ): zio.aws.devopsguru.model.TagCostEstimationResourceCollectionFilter.ReadOnly =
    new Wrapper(impl)
}
