package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{AwsAccountId, InsightId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInsightRequest(
    id: InsightId,
    accountId: Optional[AwsAccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest = {
    import DescribeInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest
      .builder()
      .id(InsightId.unwrap(id): java.lang.String)
      .optionallyWith(
        accountId.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DescribeInsightRequest.ReadOnly =
    zio.aws.devopsguru.model.DescribeInsightRequest.wrap(buildAwsValue())
}
object DescribeInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeInsightRequest =
      zio.aws.devopsguru.model
        .DescribeInsightRequest(id, accountId.map(value => value))
    def id: InsightId
    def accountId: Optional[AwsAccountId]
    def getId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(id)
    def getAccountId: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest
  ) extends zio.aws.devopsguru.model.DescribeInsightRequest.ReadOnly {
    override val id: InsightId =
      zio.aws.devopsguru.model.primitives.InsightId(impl.id())
    override val accountId: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.devopsguru.model.primitives.AwsAccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeInsightRequest
  ): zio.aws.devopsguru.model.DescribeInsightRequest.ReadOnly = new Wrapper(
    impl
  )
}
