package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.UuidNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListInsightsResponse(
    proactiveInsights: Optional[
      Iterable[zio.aws.devopsguru.model.ProactiveInsightSummary]
    ] = Optional.Absent,
    reactiveInsights: Optional[
      Iterable[zio.aws.devopsguru.model.ReactiveInsightSummary]
    ] = Optional.Absent,
    nextToken: Optional[UuidNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse = {
    import ListInsightsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse
      .builder()
      .optionallyWith(
        proactiveInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proactiveInsights)
      .optionallyWith(
        reactiveInsights.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reactiveInsights)
      .optionallyWith(
        nextToken.map(value => UuidNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly =
    zio.aws.devopsguru.model.ListInsightsResponse.wrap(buildAwsValue())
}
object ListInsightsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListInsightsResponse =
      zio.aws.devopsguru.model.ListInsightsResponse(
        proactiveInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reactiveInsights.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def proactiveInsights: Optional[
      List[zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly]
    ]
    def reactiveInsights: Optional[
      List[zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly]
    ]
    def nextToken: Optional[UuidNextToken]
    def getProactiveInsights: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("proactiveInsights", proactiveInsights)
    def getReactiveInsights: ZIO[Any, AwsError, List[
      zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("reactiveInsights", reactiveInsights)
    def getNextToken: ZIO[Any, AwsError, UuidNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse
  ) extends zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly {
    override val proactiveInsights: Optional[
      List[zio.aws.devopsguru.model.ProactiveInsightSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proactiveInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ProactiveInsightSummary.wrap(item)
        }.toList
      )
    override val reactiveInsights: Optional[
      List[zio.aws.devopsguru.model.ReactiveInsightSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reactiveInsights())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.devopsguru.model.ReactiveInsightSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[UuidNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.devopsguru.model.primitives.UuidNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListInsightsResponse
  ): zio.aws.devopsguru.model.ListInsightsResponse.ReadOnly = new Wrapper(impl)
}
