package zio.aws.devopsguru.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInsightResponse(
    proactiveInsight: Optional[zio.aws.devopsguru.model.ProactiveInsight] =
      Optional.Absent,
    reactiveInsight: Optional[zio.aws.devopsguru.model.ReactiveInsight] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse = {
    import DescribeInsightResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse
      .builder()
      .optionallyWith(proactiveInsight.map(value => value.buildAwsValue()))(
        _.proactiveInsight
      )
      .optionallyWith(reactiveInsight.map(value => value.buildAwsValue()))(
        _.reactiveInsight
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly =
    zio.aws.devopsguru.model.DescribeInsightResponse.wrap(buildAwsValue())
}
object DescribeInsightResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.DescribeInsightResponse =
      zio.aws.devopsguru.model.DescribeInsightResponse(
        proactiveInsight.map(value => value.asEditable),
        reactiveInsight.map(value => value.asEditable)
      )
    def proactiveInsight
        : Optional[zio.aws.devopsguru.model.ProactiveInsight.ReadOnly]
    def reactiveInsight
        : Optional[zio.aws.devopsguru.model.ReactiveInsight.ReadOnly]
    def getProactiveInsight: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ProactiveInsight.ReadOnly
    ] = AwsError.unwrapOptionField("proactiveInsight", proactiveInsight)
    def getReactiveInsight: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ReactiveInsight.ReadOnly
    ] = AwsError.unwrapOptionField("reactiveInsight", reactiveInsight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse
  ) extends zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly {
    override val proactiveInsight
        : Optional[zio.aws.devopsguru.model.ProactiveInsight.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proactiveInsight())
        .map(value => zio.aws.devopsguru.model.ProactiveInsight.wrap(value))
    override val reactiveInsight
        : Optional[zio.aws.devopsguru.model.ReactiveInsight.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reactiveInsight())
        .map(value => zio.aws.devopsguru.model.ReactiveInsight.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.DescribeInsightResponse
  ): zio.aws.devopsguru.model.DescribeInsightResponse.ReadOnly = new Wrapper(
    impl
  )
}
