package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{
  AnalyzedResourceCount,
  TagValue,
  AppBoundaryKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TagHealth(
    appBoundaryKey: Optional[AppBoundaryKey] = Optional.Absent,
    tagValue: Optional[TagValue] = Optional.Absent,
    insight: Optional[zio.aws.devopsguru.model.InsightHealth] = Optional.Absent,
    analyzedResourceCount: Optional[AnalyzedResourceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.TagHealth = {
    import TagHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.TagHealth
      .builder()
      .optionallyWith(
        appBoundaryKey.map(value =>
          AppBoundaryKey.unwrap(value): java.lang.String
        )
      )(_.appBoundaryKey)
      .optionallyWith(
        tagValue.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.tagValue)
      .optionallyWith(insight.map(value => value.buildAwsValue()))(_.insight)
      .optionallyWith(
        analyzedResourceCount.map(value =>
          AnalyzedResourceCount.unwrap(value): java.lang.Long
        )
      )(_.analyzedResourceCount)
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.TagHealth.ReadOnly =
    zio.aws.devopsguru.model.TagHealth.wrap(buildAwsValue())
}
object TagHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.TagHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.TagHealth =
      zio.aws.devopsguru.model.TagHealth(
        appBoundaryKey.map(value => value),
        tagValue.map(value => value),
        insight.map(value => value.asEditable),
        analyzedResourceCount.map(value => value)
      )
    def appBoundaryKey: Optional[AppBoundaryKey]
    def tagValue: Optional[TagValue]
    def insight: Optional[zio.aws.devopsguru.model.InsightHealth.ReadOnly]
    def analyzedResourceCount: Optional[AnalyzedResourceCount]
    def getAppBoundaryKey: ZIO[Any, AwsError, AppBoundaryKey] =
      AwsError.unwrapOptionField("appBoundaryKey", appBoundaryKey)
    def getTagValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("tagValue", tagValue)
    def getInsight
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.InsightHealth.ReadOnly] =
      AwsError.unwrapOptionField("insight", insight)
    def getAnalyzedResourceCount: ZIO[Any, AwsError, AnalyzedResourceCount] =
      AwsError.unwrapOptionField("analyzedResourceCount", analyzedResourceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.TagHealth
  ) extends zio.aws.devopsguru.model.TagHealth.ReadOnly {
    override val appBoundaryKey: Optional[AppBoundaryKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appBoundaryKey())
        .map(value => zio.aws.devopsguru.model.primitives.AppBoundaryKey(value))
    override val tagValue: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.tagValue())
      .map(value => zio.aws.devopsguru.model.primitives.TagValue(value))
    override val insight
        : Optional[zio.aws.devopsguru.model.InsightHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insight())
        .map(value => zio.aws.devopsguru.model.InsightHealth.wrap(value))
    override val analyzedResourceCount: Optional[AnalyzedResourceCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzedResourceCount())
        .map(value =>
          zio.aws.devopsguru.model.primitives.AnalyzedResourceCount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.TagHealth
  ): zio.aws.devopsguru.model.TagHealth.ReadOnly = new Wrapper(impl)
}
