package zio.aws.devopsguru.model
import zio.aws.devopsguru.model.primitives.{EventSource, InsightId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEventsFilters(
    insightId: Optional[InsightId] = Optional.Absent,
    eventTimeRange: Optional[zio.aws.devopsguru.model.EventTimeRange] =
      Optional.Absent,
    eventClass: Optional[zio.aws.devopsguru.model.EventClass] = Optional.Absent,
    eventSource: Optional[EventSource] = Optional.Absent,
    dataSource: Optional[zio.aws.devopsguru.model.EventDataSource] =
      Optional.Absent,
    resourceCollection: Optional[zio.aws.devopsguru.model.ResourceCollection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.devopsguru.model.ListEventsFilters = {
    import ListEventsFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.devopsguru.model.ListEventsFilters
      .builder()
      .optionallyWith(
        insightId.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.insightId)
      .optionallyWith(eventTimeRange.map(value => value.buildAwsValue()))(
        _.eventTimeRange
      )
      .optionallyWith(eventClass.map(value => value.unwrap))(_.eventClass)
      .optionallyWith(
        eventSource.map(value => EventSource.unwrap(value): java.lang.String)
      )(_.eventSource)
      .optionallyWith(dataSource.map(value => value.unwrap))(_.dataSource)
      .optionallyWith(resourceCollection.map(value => value.buildAwsValue()))(
        _.resourceCollection
      )
      .build()
  }
  def asReadOnly: zio.aws.devopsguru.model.ListEventsFilters.ReadOnly =
    zio.aws.devopsguru.model.ListEventsFilters.wrap(buildAwsValue())
}
object ListEventsFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.devopsguru.model.ListEventsFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.devopsguru.model.ListEventsFilters =
      zio.aws.devopsguru.model.ListEventsFilters(
        insightId.map(value => value),
        eventTimeRange.map(value => value.asEditable),
        eventClass.map(value => value),
        eventSource.map(value => value),
        dataSource.map(value => value),
        resourceCollection.map(value => value.asEditable)
      )
    def insightId: Optional[InsightId]
    def eventTimeRange
        : Optional[zio.aws.devopsguru.model.EventTimeRange.ReadOnly]
    def eventClass: Optional[zio.aws.devopsguru.model.EventClass]
    def eventSource: Optional[EventSource]
    def dataSource: Optional[zio.aws.devopsguru.model.EventDataSource]
    def resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly]
    def getInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("insightId", insightId)
    def getEventTimeRange
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.EventTimeRange.ReadOnly] =
      AwsError.unwrapOptionField("eventTimeRange", eventTimeRange)
    def getEventClass: ZIO[Any, AwsError, zio.aws.devopsguru.model.EventClass] =
      AwsError.unwrapOptionField("eventClass", eventClass)
    def getEventSource: ZIO[Any, AwsError, EventSource] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getDataSource
        : ZIO[Any, AwsError, zio.aws.devopsguru.model.EventDataSource] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getResourceCollection: ZIO[
      Any,
      AwsError,
      zio.aws.devopsguru.model.ResourceCollection.ReadOnly
    ] = AwsError.unwrapOptionField("resourceCollection", resourceCollection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.devopsguru.model.ListEventsFilters
  ) extends zio.aws.devopsguru.model.ListEventsFilters.ReadOnly {
    override val insightId: Optional[InsightId] = zio.aws.core.internal
      .optionalFromNullable(impl.insightId())
      .map(value => zio.aws.devopsguru.model.primitives.InsightId(value))
    override val eventTimeRange
        : Optional[zio.aws.devopsguru.model.EventTimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventTimeRange())
        .map(value => zio.aws.devopsguru.model.EventTimeRange.wrap(value))
    override val eventClass: Optional[zio.aws.devopsguru.model.EventClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventClass())
        .map(value => zio.aws.devopsguru.model.EventClass.wrap(value))
    override val eventSource: Optional[EventSource] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSource())
      .map(value => zio.aws.devopsguru.model.primitives.EventSource(value))
    override val dataSource
        : Optional[zio.aws.devopsguru.model.EventDataSource] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataSource())
        .map(value => zio.aws.devopsguru.model.EventDataSource.wrap(value))
    override val resourceCollection
        : Optional[zio.aws.devopsguru.model.ResourceCollection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceCollection())
        .map(value => zio.aws.devopsguru.model.ResourceCollection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.devopsguru.model.ListEventsFilters
  ): zio.aws.devopsguru.model.ListEventsFilters.ReadOnly = new Wrapper(impl)
}
